
-- Localize it for non-English clients.
FOCUSFRAME_TITLE = "Focus";
FOCUSFRAME_DRAG = "Drag to move";
FOCUSFRAME_DRAG_LOCKED = "Use /focusframe unlock to move.";

if GetLocale() == "zhCN" then
  FOCUSFRAME_TITLE = "\231\132\166\231\130\185\231\155\174\230\160\135"
  FOCUSFRAME_DRAG = "\230\140\137\228\189\143\233\188\160\230\160\135\229\183\166\233\148\174\230\139\150\229\138\168\230\157\165\231\167\187\229\138\168\230\161\134\228\189\147"
  FOCUSFRAME_DRAG_LOCKED = "\228\189\191\231\148\168 /focusframe unlock"
elseif GetLocale() == "zhTW" then
  FOCUSFRAME_TITLE = "\231\132\166\233\187\158\231\155\174\230\168\153"
  FOCUSFRAME_DRAG = "\230\140\137\228\189\143\230\187\145\233\188\160\229\183\166\233\141\181\230\139\150\229\139\149\228\190\134\231\167\187\229\139\149\230\161\134\233\171\148"
  FOCUSFRAME_DRAG_LOCKED = "\228\189\191\231\148\168 /focusframe unlock"
end

local i,j,k;

-- Saved variables
FocusFrameOptions = FocusFrameOptions or {};

local function TgFocusFrame_SlashCommand(msg)
  local cmd,var = strsplit(' ', msg or "")
  if cmd == "scale" and tonumber(var) then
    TgFocusFrame_SetScale(var);
  elseif cmd == "reset" then
    TgFocusFrame_Reset();
  elseif cmd == "lock" then
    FocusFrameOptions.lockpos = true;
  elseif cmd == "unlock" then
    FocusFrameOptions.lockpos = nil;
  elseif cmd == "hidewhendead" then
    TgFocusFrame_HideWhenDead(true);
  else
    TgFocusFrame_Help();
  end
end
SlashCmdList["FOCUSFRAME"] = TgFocusFrame_SlashCommand;
SLASH_FOCUSFRAME1 = "/focusframe";

function TgFocusFrame_Help()
  DEFAULT_CHAT_FRAME:AddMessage('FocusFrame usage:');
  DEFAULT_CHAT_FRAME:AddMessage('/focusframe scale <num> : Set scale (e.g. /focusframe scale 0.7).');
  DEFAULT_CHAT_FRAME:AddMessage('/focusframe reset : Reset position.');
  DEFAULT_CHAT_FRAME:AddMessage('/focusframe lock : Lock position.');
  DEFAULT_CHAT_FRAME:AddMessage('/focusframe unlock : Unlock position.');
  DEFAULT_CHAT_FRAME:AddMessage('/focusframe hidewhendead : Hide when focused enemy target is dead. ['..((FocusFrameOptions.hidewhendead and 'ON') or 'OFF')..']');
end

function TgFocusFrame_SetScale(scale)
  if InCombatLockdown() then
    DEFAULT_CHAT_FRAME:AddMessage('FocusFrame: You cannot change scale while in combat.');
    return;
  end

  scalenum = tonumber(scale);
  if scalenum and scalenum <= 10 then
    TgFocusFrame_SavePos();
	FocusFrameOptions.yOfs = FocusFrameOptions.yOfs * FocusFrameOptions.scale / scalenum;
	FocusFrameOptions.xOfs = FocusFrameOptions.xOfs * FocusFrameOptions.scale / scalenum;
    FocusFrameOptions.scale = scalenum;
	TgFocusFrame_RestorePos();
  else
    DEFAULT_CHAT_FRAME:AddMessage('Usage: /focusframe scale <num> : Set scale (e.g. /focusframe scale 0.7).');
  end
end

function TgFocusFrame_SavePos()
  local point, relativeTo, relativePoint, xOfs, yOfs = TgFocusFrame:GetPoint(1);
  FocusFrameOptions.scale = TgFocusFrame:GetScale();
  FocusFrameOptions.point = point;
  FocusFrameOptions.relativePoint = relativePoint;
  FocusFrameOptions.yOfs = yOfs;
  FocusFrameOptions.xOfs = xOfs;
end

function TgFocusFrame_RestorePos()
  if FocusFrameOptions.point
   and FocusFrameOptions.relativePoint
   and FocusFrameOptions.xOfs
   and FocusFrameOptions.yOfs
  then
    TgFocusFrame:SetScale(FocusFrameOptions.scale);
    TgFocusFrame:SetPoint(FocusFrameOptions.point,
        UIParent, FocusFrameOptions.relativePoint,
        FocusFrameOptions.xOfs, FocusFrameOptions.yOfs);
    return true;
  else
    return false;
  end
end

function TgFocusFrame_Reset()
  TgFocusFrame:SetPoint("TOPLEFT", UIParent, "CENTER", 0, 0);
  TgFocusFrame_SavePos();
end

function TgFocusFrame_HideWhenDead(toggle)
  if FocusFrameOptions.hidewhendead == nil then
    -- Default is ON
    FocusFrameOptions.hidewhendead = true;
  end
  if toggle then
    if InCombatLockdown() then
      DEFAULT_CHAT_FRAME:AddMessage('FocusFrame: You cannot toggle hidewhendead while in combat.');
      return;
    end
    if FocusFrameOptions.hidewhendead then
      FocusFrameOptions.hidewhendead = false;
        DEFAULT_CHAT_FRAME:AddMessage('FocusFrame: hidewhendead is now [OFF]. FocusFrame will be always shown.');
    else
      FocusFrameOptions.hidewhendead = true;
        DEFAULT_CHAT_FRAME:AddMessage('FocusFrame: hidewhendead is now [ON]. FocusFrame will be hide when enemy target is dead.');
    end
  end
  if FocusFrameOptions.hidewhendead then
    RegisterStateDriver(TgFocusFrame, "visibility", "[target=focus,noexists][target=focus,harm,dead]hide;show");
  else
    RegisterStateDriver(TgFocusFrame, "visibility", "[target=focus,noexists]hide;show");
  end
end

-- Borrowed from XPerl
function TgFocusFrame_BlizzFrameDisable(self)
  UnregisterUnitWatch(self)    -- Should stop Archaeologist from re-showing target frame
  self:UnregisterAllEvents()
  self:Hide()
  -- Make it so it won't be visible, even if shown by another mod
  self:ClearAllPoints()
  self:SetPoint("BOTTOMLEFT", UIParent, "TOPLEFT", -400, 500)

  local healthBar = getglobal(self:GetName().."HealthBar")
  if (healthBar) then
    healthBar:UnregisterAllEvents()
  end

  local manaBar = getglobal(self:GetName().."ManaBar")
  if (manaBar) then
    manaBar:UnregisterAllEvents()
  end
end

local MAX_TARGET_DEBUFFS = 16;
local MAX_TARGET_BUFFS = 32;

-- aura positioning constants
local AURA_START_X = 5;
local AURA_START_Y = 32;
local AURA_OFFSET_Y = 3;
local LARGE_AURA_SIZE = 21;
local SMALL_AURA_SIZE = 17;
local AURA_ROW_WIDTH = 122;
local TOT_AURA_ROW_WIDTH = 101;
local NUM_TOT_AURA_ROWS = 2;  -- TODO: replace with TOT_AURA_ROW_HEIGHT functionality if this becomes a problem

local PLAYER_UNITS = {
  player = true,
  vehicle = true,
  pet = true,
};

function TgFocusFrame_OnLoad (self)
    TgFocusFrame_BlizzFrameDisable(FocusFrame);
  self.statusCounter = 0;
  self.statusSign = -1;
  self.unitHPPercent = 1;

  TgFocusFrame_Update(self);
  self:RegisterEvent("PLAYER_ENTERING_WORLD");
  self:RegisterEvent("PLAYER_FOCUS_CHANGED");
  self:RegisterEvent("UNIT_HEALTH");
  self:RegisterEvent("UNIT_LEVEL");
  self:RegisterEvent("UNIT_FACTION");
  self:RegisterEvent("UNIT_CLASSIFICATION_CHANGED");
  self:RegisterEvent("UNIT_AURA");
  self:RegisterEvent("PLAYER_FLAGS_CHANGED");
  self:RegisterEvent("PARTY_MEMBERS_CHANGED");
  self:RegisterEvent("RAID_TARGET_UPDATE");
  self:RegisterEvent("PLAYER_LOGIN");

  local frameLevel = TgFocusFrameTextureFrame:GetFrameLevel();
  TgFocusFrameHealthBar:SetFrameLevel(frameLevel-1);
  TgFocusFrameManaBar:SetFrameLevel(frameLevel-1);
  TgFocusFrameSpellBar:SetFrameLevel(frameLevel-1);

  local showmenu = function()
    ToggleDropDownMenu(1, nil, TgFocusFrameDropDown, "TgFocusFrame", 120, 10);
  end
  SecureUnitButton_OnLoad(self, "focus", showmenu);

    ClickCastFrames = ClickCastFrames or { };
    ClickCastFrames[self] = true;
end

function TgFocusFrame_Update (self)
  if ( UnitExists("focus") ) then
    TgTargetofFocus_Update();

    UnitFrame_Update(self);
    TgFocusFrame_CheckLevel(self);
    TgFocusFrame_CheckFaction(self);
    TgFocusFrame_CheckClassification(self);
    TgFocusFrame_CheckDead(self);
    if ( UnitIsPartyLeader("focus") ) then
      TgFocusLeaderIcon:Show();
    else
      TgFocusLeaderIcon:Hide();
    end
    TgFocusFrame_UpdateAuras(self);
    TgFocusPortrait:SetAlpha(1.0);
  end
end

function TgFocusFrame_OnEvent (self, event, ...)
  UnitFrame_OnEvent(self, event, ...);

  local arg1 = ...;
  if ( event == "PLAYER_ENTERING_WORLD" ) then
    TgFocusFrame_Update(self);
  elseif ( event == "PLAYER_FOCUS_CHANGED" ) then
    TgFocusFrame_Update(self);
    TgFocusFrame_UpdateRaidTargetIcon(self);
    CloseDropDownMenus();

  elseif ( event == "UNIT_HEALTH" ) then
    if ( arg1 == "focus" ) then
      TgFocusFrame_CheckDead(self);
    end
  elseif ( event == "UNIT_LEVEL" ) then
    if ( arg1 == "focus" ) then
      TgFocusFrame_CheckLevel(self);
    end
  elseif ( event == "UNIT_FACTION" ) then
    if ( arg1 == "focus" or arg1 == "player" ) then
      TgFocusFrame_CheckFaction(self);
      TgFocusFrame_CheckLevel(self);
    end
  elseif ( event == "UNIT_CLASSIFICATION_CHANGED" ) then
    if ( arg1 == "focus" ) then
      TgFocusFrame_CheckClassification(self);
    end
  elseif ( event == "UNIT_AURA" ) then
    if ( arg1 == "focus" ) then
      TgFocusFrame_UpdateAuras(self);
    end
  elseif ( event == "PLAYER_FLAGS_CHANGED" ) then
    if ( arg1 == "focus" ) then
      if ( UnitIsPartyLeader("focus") ) then
        TgFocusLeaderIcon:Show();
      else
        TgFocusLeaderIcon:Hide();
      end
    end
  elseif ( event == "PARTY_MEMBERS_CHANGED" ) then
    TgTargetofFocus_Update();
    TgFocusFrame_CheckFaction(self);
  elseif ( event == "RAID_TARGET_UPDATE" ) then
    TgFocusFrame_UpdateRaidTargetIcon(self);
    elseif ( event == "PLAYER_LOGIN" ) then
        FocusFrameOptions.scale = FocusFrameOptions.scale or 1;
    if TgFocusFrame_RestorePos() == false then
      TgFocusFrame_SetScale(FocusFrameOptions.scale);
    end
    TgFocusFrame_HideWhenDead(false);
  end
end

function TgFocusFrame_OnHide (self)
  PlaySound("INTERFACESOUND_LOSTTARGETUNIT");
  CloseDropDownMenus();
end

function TgFocusFrame_CheckLevel (self)
  local targetLevel = UnitLevel("focus");
  
  if ( UnitIsCorpse("focus") ) then
    TgFocusLevelText:Hide();
    TgFocusHighLevelTexture:Show();
  elseif ( targetLevel > 0 ) then
    -- Normal level target
    TgFocusLevelText:SetText(targetLevel);
    -- Color level number
    if ( UnitCanAttack("player", "focus") ) then
      local color = GetQuestDifficultyColor(targetLevel);
      TgFocusLevelText:SetVertexColor(color.r, color.g, color.b);
    else
      TgFocusLevelText:SetVertexColor(1.0, 0.82, 0.0);
    end
    TgFocusLevelText:Show();
    TgFocusHighLevelTexture:Hide();
  else
    -- Target is too high level to tell
    TgFocusLevelText:Hide();
    TgFocusHighLevelTexture:Show();
  end
end

function TgFocusFrame_CheckFaction (self)
  if ( not UnitPlayerControlled("focus") and UnitIsTapped("focus") and not UnitIsTappedByPlayer("focus") and not UnitIsTappedByAllThreatList("focus") ) then
    TgFocusFrameNameBackground:SetVertexColor(0.5, 0.5, 0.5);
    TgFocusPortrait:SetVertexColor(0.5, 0.5, 0.5);
  else
    TgFocusFrameNameBackground:SetVertexColor(UnitSelectionColor("focus"));
    TgFocusPortrait:SetVertexColor(1.0, 1.0, 1.0);
  end

  local factionGroup = UnitFactionGroup("focus");
  if ( UnitIsPVPFreeForAll("focus") ) then
    TgFocusPVPIcon:SetTexture("Interface\\TargetingFrame\\UI-PVP-FFA");
    TgFocusPVPIcon:Show();
  elseif ( factionGroup and UnitIsPVP("focus") ) then
    TgFocusPVPIcon:SetTexture("Interface\\TargetingFrame\\UI-PVP-"..factionGroup);
    TgFocusPVPIcon:Show();
  else
    TgFocusPVPIcon:Hide();
  end
end

function TgFocusFrame_CheckClassification (self)
  local classification = UnitClassification("focus");
  if ( classification == "worldboss" ) then
    TgFocusFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Elite");
    TgFocusFrameFlash:SetTexCoord(0, 0.9453125, 0.181640625, 0.400390625);
    TgFocusFrameFlash:SetWidth(242);
    TgFocusFrameFlash:SetHeight(112);
    TgFocusFrameFlash:SetPoint("TOPLEFT", TgFocusFrame, "TOPLEFT", -22, 9);
  elseif ( classification == "rareelite"  ) then
    TgFocusFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Rare-Elite");
    TgFocusFrameFlash:SetTexCoord(0, 0.9453125, 0.181640625, 0.400390625);
    TgFocusFrameFlash:SetWidth(242);
    TgFocusFrameFlash:SetHeight(112);
    TgFocusFrameFlash:SetPoint("TOPLEFT", TgFocusFrame, "TOPLEFT", -22, 9);
  elseif ( classification == "elite"  ) then
    TgFocusFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Elite");
    TgFocusFrameFlash:SetTexCoord(0, 0.9453125, 0.181640625, 0.400390625);
    TgFocusFrameFlash:SetWidth(242);
    TgFocusFrameFlash:SetHeight(112);
    TgFocusFrameFlash:SetPoint("TOPLEFT", TgFocusFrame, "TOPLEFT", -22, 9);
  elseif ( classification == "rare"  ) then
    TgFocusFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-Rare");
    TgFocusFrameFlash:SetTexCoord(0, 0.9453125, 0.181640625, 0.400390625);
    TgFocusFrameFlash:SetWidth(242);
    TgFocusFrameFlash:SetHeight(112);
    TgFocusFrameFlash:SetPoint("TOPLEFT", TgFocusFrame, "TOPLEFT", -22, 9);
  else
    TgFocusFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame");
    TgFocusFrameFlash:SetTexCoord(0, 0.9453125, 0, 0.181640625);
    TgFocusFrameFlash:SetWidth(242);
    TgFocusFrameFlash:SetHeight(93);
    TgFocusFrameFlash:SetPoint("TOPLEFT", TgFocusFrame, "TOPLEFT", -24, 0);
  end
end

function TgFocusFrame_CheckDead (self)
  if ( (UnitHealth("focus") <= 0) and UnitIsConnected("focus") ) then
    TgFocusDeadText:Show();
  else
    TgFocusDeadText:Hide();
  end
end

function TgFocusFrame_OnUpdate (self, elapsed)
  if ( TgTargetofFocusFrame:IsShown() ~= UnitExists("focustarget") ) then
    TgTargetofFocus_Update();
  end
  
  self.elapsed = (self.elapsed or 0) + elapsed;
  if ( self.elapsed > 0.5 ) then
    self.elapsed = 0;
    UnitFrame_UpdateThreatIndicator(self.threatIndicator, self.threatNumericIndicator, self.feedbackUnit);
  end
end

local largeBuffList = {};
local largeDebuffList = {};

function TgFocusFrame_UpdateAuras (self)
  local frame, frameName;
  local frameIcon, frameCount, frameCooldown;

  local name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable;
  local playerIsTarget = UnitIsUnit(PlayerFrame.unit, "focus");

  local frameStealable;
  local numBuffs = 0;
  for i=1, MAX_TARGET_BUFFS do
    name, rank, icon, count, debuffType, duration, expirationTime, caster, isStealable = UnitBuff("focus", i);
    frameName = "TgFocusFrameBuff"..i;
    frame = _G[frameName];
    if ( not frame ) then
      if ( not icon ) then
        break;
      else
        frame = CreateFrame("Button", frameName, TgFocusFrame, "TgFocusBuffFrameTemplate");
        frame.unit = "focus";
      end
    end
    if ( icon ) then
      frame:SetID(i);

      -- set the icon
      frameIcon = _G[frameName.."Icon"];
      frameIcon:SetTexture(icon);

      -- set the count
      frameCount = _G[frameName.."Count"];
      if ( count > 1 ) then
        frameCount:SetText(count);
        frameCount:Show();
      else
        frameCount:Hide();
      end

      -- Handle cooldowns
      frameCooldown = _G[frameName.."Cooldown"];
      if ( duration > 0 ) then
        frameCooldown:Show();
        CooldownFrame_SetTimer(frameCooldown, expirationTime - duration, duration, 1);
      else
        frameCooldown:Hide();
      end

      -- Show stealable frame if the target is not a player and the buff is stealable.
      frameStealable = _G[frameName.."Stealable"];
      if ( not playerIsTarget and isStealable ) then
        frameStealable:Show();
      else
        frameStealable:Hide();
      end

      -- set the buff to be big if the target is not the player and the buff is cast by the player or his pet
      largeBuffList[i] = (not playerIsTarget and PLAYER_UNITS[caster]);

      numBuffs = numBuffs + 1;

      frame:ClearAllPoints();
      frame:Show();
    else
      frame:Hide();
    end
  end

  local color;
  local frameBorder;
  local numDebuffs = 0;
  for i=1, MAX_TARGET_DEBUFFS do
    name, rank, icon, count, debuffType, duration, expirationTime, caster = UnitDebuff("focus", i);
    frameName = "TgFocusFrameDebuff"..i;
    frame = _G[frameName];
    if ( not frame ) then
      if ( not icon ) then
        break;
      else
        frame = CreateFrame("Button", frameName, TgFocusFrame, "TgFocusDebuffFrameTemplate");
        frame.unit = "focus";
      end
    end
    if ( icon ) then
      frame:SetID(i);

      -- set the icon
      frameIcon = _G[frameName.."Icon"];
      frameIcon:SetTexture(icon);

      -- set the count
      frameCount = _G[frameName.."Count"];
      if ( count > 1 ) then
        frameCount:SetText(count);
        frameCount:Show();
      else
        frameCount:Hide();
      end

      -- Handle cooldowns
      frameCooldown = _G[frameName.."Cooldown"];
      if ( duration > 0 ) then
        frameCooldown:Show();
        CooldownFrame_SetTimer(frameCooldown, expirationTime - duration, duration, 1);
      else
        frameCooldown:Hide();
      end

      -- set debuff type color
      if ( debuffType ) then
        color = DebuffTypeColor[debuffType];
      else
        color = DebuffTypeColor["none"];
      end
      frameBorder = _G[frameName.."Border"];
      frameBorder:SetVertexColor(color.r, color.g, color.b);

      -- set the debuff to be big if the buff is cast by the player or his pet
      largeDebuffList[i] = (PLAYER_UNITS[caster]);

      numDebuffs = numDebuffs + 1;

      frame:ClearAllPoints();
      frame:Show();
    else
      frame:Hide();
    end
  end

  TgFocusFrame.auraRows = 0;
  local haveTargetofTarget = TgTargetofFocusFrame:IsShown();
  local maxRowWidth;
  -- update buff positions
  maxRowWidth = ( haveTargetofTarget and TOT_AURA_ROW_WIDTH ) or AURA_ROW_WIDTH;
  TgFocusFrame_UpdateAuraPositions("TgFocusFrameBuff", numBuffs, numDebuffs, largeBuffList, TgFocusFrame_UpdateBuffAnchor, maxRowWidth, 3);
  -- update debuff positions
  maxRowWidth = ( haveTargetofTarget and TgFocusFrame.auraRows < NUM_TOT_AURA_ROWS and TOT_AURA_ROW_WIDTH ) or AURA_ROW_WIDTH;
  TgFocusFrame_UpdateAuraPositions("TgFocusFrameDebuff", numDebuffs, numBuffs, largeDebuffList, TgFocusFrame_UpdateDebuffAnchor, maxRowWidth, 4);
  -- update the spell bar position
  TgFocus_Spellbar_AdjustPosition();
end

function TgFocusFrame_UpdateAuraPositions(auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX)
  -- a lot of this complexity is in place to allow the auras to wrap around the target of target frame if it's shown

  -- Position auras
  local size;
  local offsetY = AURA_OFFSET_Y;
  -- current width of a row, increases as auras are added and resets when a new aura's width exceeds the max row width
  local rowWidth = 0;
  local firstBuffOnRow = 1;
  for i=1, numAuras do
    -- update size and offset info based on large aura status
    if ( largeAuraList[i] ) then
      size = LARGE_AURA_SIZE;
      offsetY = AURA_OFFSET_Y + AURA_OFFSET_Y;
    else
      size = SMALL_AURA_SIZE;
    end

    -- anchor the current aura
    if ( i == 1 ) then
      rowWidth = size;
      TgFocusFrame.auraRows = TgFocusFrame.auraRows + 1;
    else
      rowWidth = rowWidth + size + offsetX;
    end
    if ( rowWidth > maxRowWidth ) then
      -- this aura would cause the current row to exceed the max row width, so make this aura
      -- the start of a new row instead
      updateFunc(auraName, i, numOppositeAuras, firstBuffOnRow, size, offsetX, offsetY);

      rowWidth = size;
      TgFocusFrame.auraRows = TgFocusFrame.auraRows + 1;
      firstBuffOnRow = i;
      offsetY = AURA_OFFSET_Y;

      if ( TgFocusFrame.auraRows > NUM_TOT_AURA_ROWS ) then
        -- if we exceed the number of tot rows, then reset the max row width
        -- note: don't have to check if we have tot because AURA_ROW_WIDTH is the default anyway
        maxRowWidth = AURA_ROW_WIDTH;
      end
    else
      updateFunc(auraName, i, numOppositeAuras, i - 1, size, offsetX, offsetY);
    end
  end
end

function TgFocusFrame_UpdateBuffAnchor(buffName, index, numDebuffs, anchorIndex, size, offsetX, offsetY)
  local buff = _G[buffName..index];

  if ( index == 1 ) then
    if ( UnitIsFriend("player", "focus") or numDebuffs == 0 ) then
      -- unit is friendly or there are no debuffs...buffs start on top
      buff:SetPoint("TOPLEFT", TgFocusFrame, "BOTTOMLEFT", AURA_START_X, AURA_START_Y);
    else
      -- unit is not friendly and we have debuffs...buffs start on bottom
      buff:SetPoint("TOPLEFT", TgFocusFrameDebuffs, "BOTTOMLEFT", 0, -offsetY);
    end
    TgFocusFrameBuffs:SetPoint("TOPLEFT", buff, "TOPLEFT", 0, 0);
    TgFocusFrameBuffs:SetPoint("BOTTOMLEFT", buff, "BOTTOMLEFT", 0, -AURA_OFFSET_Y);
  elseif ( anchorIndex ~= (index-1) ) then
    -- anchor index is not the previous index...must be a new row
    buff:SetPoint("TOPLEFT", _G[buffName..anchorIndex], "BOTTOMLEFT", 0, -offsetY);
    TgFocusFrameBuffs:SetPoint("BOTTOMLEFT", buff, "BOTTOMLEFT", 0, -AURA_OFFSET_Y);
  else
    -- anchor index is the previous index
    buff:SetPoint("TOPLEFT", _G[buffName..anchorIndex], "TOPRIGHT", offsetX, 0);
  end

  -- Resize
  buff:SetWidth(size);
  buff:SetHeight(size);
end

function TgFocusFrame_UpdateDebuffAnchor(debuffName, index, numBuffs, anchorIndex, size, offsetX, offsetY)
  local buff = _G[debuffName..index];

  if ( index == 1 ) then
    if ( UnitIsFriend("player", "focus") and numBuffs > 0 ) then
      -- unit is friendly and there are buffs...debuffs start on bottom
      buff:SetPoint("TOPLEFT", TgFocusFrameBuffs, "BOTTOMLEFT", 0, -offsetY);
    else
      -- unit is not friendly or there are no buffs...debuffs start on top
      buff:SetPoint("TOPLEFT", TgFocusFrame, "BOTTOMLEFT", AURA_START_X, AURA_START_Y);
    end
    TgFocusFrameDebuffs:SetPoint("TOPLEFT", buff, "TOPLEFT", 0, 0);
    TgFocusFrameDebuffs:SetPoint("BOTTOMLEFT", buff, "BOTTOMLEFT", 0, -AURA_OFFSET_Y);
  elseif ( anchorIndex ~= (index-1) ) then
    -- anchor index is not the previous index...must be a new row
    buff:SetPoint("TOPLEFT", _G[debuffName..anchorIndex], "BOTTOMLEFT", 0, -offsetY);
    TgFocusFrameDebuffs:SetPoint("BOTTOMLEFT", buff, "BOTTOMLEFT", 0, -AURA_OFFSET_Y);
  else
    -- anchor index is the previous index
    buff:SetPoint("TOPLEFT", _G[debuffName..(index-1)], "TOPRIGHT", offsetX, 0);
  end

  -- Resize
  buff:SetWidth(size);
  buff:SetHeight(size);
  local debuffFrame =_G[debuffName..index.."Border"];
  debuffFrame:SetWidth(size+2);
  debuffFrame:SetHeight(size+2);
end

function TgFocusFrame_HealthUpdate (self, elapsed, unit)
  if ( UnitIsPlayer(unit) ) then
    if ( (self.unitHPPercent > 0) and (self.unitHPPercent <= 0.2) ) then
      local alpha = 255;
      local counter = self.statusCounter + elapsed;
      local sign    = self.statusSign;
  
      if ( counter > 0.5 ) then
        sign = -sign;
        self.statusSign = sign;
      end
      counter = mod(counter, 0.5);
      self.statusCounter = counter;
  
      if ( sign == 1 ) then
        alpha = (127  + (counter * 256)) / 255;
      else
        alpha = (255 - (counter * 256)) / 255;
      end
      TgFocusPortrait:SetAlpha(alpha);
    end
  end
end

function TgFocusHealthCheck (self)
  if ( UnitIsPlayer("focus") ) then
    local unitHPMin, unitHPMax, unitCurrHP;
    unitHPMin, unitHPMax = self:GetMinMaxValues();
    unitCurrHP = self:GetValue();
    self:GetParent().unitHPPercent = unitCurrHP / unitHPMax;
    if ( UnitIsDead("focus") ) then
      TgFocusPortrait:SetVertexColor(0.35, 0.35, 0.35, 1.0);
    elseif ( UnitIsGhost("focus") ) then
      TgFocusPortrait:SetVertexColor(0.2, 0.2, 0.75, 1.0);
    elseif ( (self:GetParent().unitHPPercent > 0) and (self:GetParent().unitHPPercent <= 0.2) ) then
      TgFocusPortrait:SetVertexColor(1.0, 0.0, 0.0);
    else
      TgFocusPortrait:SetVertexColor(1.0, 1.0, 1.0, 1.0);
    end
  end
end

function TgFocusFrameDropDown_OnLoad (self)
  UIDropDownMenu_Initialize(self, TgFocusFrameDropDown_Initialize, "MENU");
end

function TgFocusFrameDropDown_Initialize (self)
  local menu;
  local name;
  local id = nil;
  if ( UnitIsUnit("focus", "player") ) then
    menu = "SELF";
  elseif ( UnitIsUnit("focus", "vehicle") ) then
    -- NOTE: vehicle check must come before pet check for accuracy's sake because
    -- a vehicle may also be considered your pet
    menu = "VEHICLE";
  elseif ( UnitIsUnit("focus", "pet") ) then
    menu = "PET";
  elseif ( UnitIsPlayer("focus") ) then
    id = UnitInRaid("focus");
    if ( id ) then
      menu = "RAID_PLAYER";
      name = GetRaidRosterInfo(id +1);
    elseif ( UnitInParty("focus") ) then
      menu = "PARTY";
    else
      menu = "PLAYER";
    end
  else
    menu = "RAID_TARGET_ICON";
    name = RAID_TARGET_ICON;
  end
  if ( menu ) then
    UnitPopup_ShowMenu(self, menu, "focus", name, id);
  end
end



-- Raid target icon function
local RAID_TARGET_ICON_DIMENSION = 64;
local RAID_TARGET_TEXTURE_DIMENSION = 256;
local RAID_TARGET_TEXTURE_COLUMNS = 4;
local RAID_TARGET_TEXTURE_ROWS = 4;
function TgFocusFrame_UpdateRaidTargetIcon (self)
  local index = GetRaidTargetIndex("focus");
  if ( index ) then
    TgSetRaidTargetIconTexture(TgFocusRaidTargetIcon, index);
    TgFocusRaidTargetIcon:Show();
  else
    TgFocusRaidTargetIcon:Hide();
  end
end


function TgSetRaidTargetIconTexture (texture, raidTargetIconIndex)
  raidTargetIconIndex = raidTargetIconIndex - 1;
  local left, right, top, bottom;
  local coordIncrement = RAID_TARGET_ICON_DIMENSION / RAID_TARGET_TEXTURE_DIMENSION;
  left = mod(raidTargetIconIndex , RAID_TARGET_TEXTURE_COLUMNS) * coordIncrement;
  right = left + coordIncrement;
  top = floor(raidTargetIconIndex / RAID_TARGET_TEXTURE_ROWS) * coordIncrement;
  bottom = top + coordIncrement;
  texture:SetTexCoord(left, right, top, bottom);
end

function TgTargetofFocus_OnLoad (self)
  UnitFrame_Initialize(self, "focustarget", TgTargetofFocusName, TgTargetofFocusPortrait,
    TgTargetofFocusHealthBar, TgTargetofFocusHealthBarText,
    TgTargetofFocusManaBar, TgTargetofFocusFrameManaBarText,
    TgTargetofFocusThreatIndicator, "player");
  SetTextStatusBarTextZeroText(TgTargetofFocusHealthBar, DEAD);
  self:RegisterEvent("UNIT_AURA");

  SecureUnitButton_OnLoad(self, "focustarget");

  RegisterUnitWatch(TgTargetofFocusFrame);  
    ClickCastFrames = ClickCastFrames or { };
    ClickCastFrames[self] = true;
end

function TgTargetofFocus_OnHide (self)
  TgFocusFrame_UpdateAuras(self);
end

function TgTargetofFocus_Update (self, elapsed)
  if ( not self ) then
    self = TgTargetofFocusFrame;
  end
  if ( TgTargetofFocusFrame:IsShown() ) then
    UnitFrame_Update(self);
    TgTargetofFocus_CheckDead();
    TgTargetofFocusHealthCheck();
    RefreshDebuffs(TgTargetofFocusFrame, "focustarget");
  end
end

function TgTargetofFocus_CheckDead ()
  if ( (UnitHealth("focustarget") <= 0) and UnitIsConnected("focustarget") ) then
    TgTargetofFocusBackground:SetAlpha(0.9);
    TgTargetofFocusDeadText:Show();
  else
    TgTargetofFocusBackground:SetAlpha(1);
    TgTargetofFocusDeadText:Hide();
  end
end

function TgTargetofFocusHealthCheck ()
  if ( UnitIsPlayer("focustarget") ) then
    local unitHPMin, unitHPMax, unitCurrHP;
    unitHPMin, unitHPMax = TgTargetofFocusHealthBar:GetMinMaxValues();
    unitCurrHP = TgTargetofFocusHealthBar:GetValue();
    TgTargetofFocusFrame.unitHPPercent = unitCurrHP / unitHPMax;
    if ( UnitIsDead("focustarget") ) then
      TgTargetofFocusPortrait:SetVertexColor(0.35, 0.35, 0.35, 1.0);
    elseif ( UnitIsGhost("focustarget") ) then
      TgTargetofFocusPortrait:SetVertexColor(0.2, 0.2, 0.75, 1.0);
    elseif ( (TgTargetofFocusFrame.unitHPPercent > 0) and (TgTargetofFocusFrame.unitHPPercent <= 0.2) ) then
      TgTargetofFocusPortrait:SetVertexColor(1.0, 0.0, 0.0);
    else
      TgTargetofFocusPortrait:SetVertexColor(1.0, 1.0, 1.0, 1.0);
    end
  end
end


function TgSetTargetSpellbarAspect()
  local targetFrameSpellBarName = TgFocusFrameSpellBar:GetName();

  local frameText = _G[targetFrameSpellBarName.."Text"];
  if ( frameText ) then
    frameText:SetFontObject(SystemFont_Shadow_Small);
    frameText:ClearAllPoints();
    frameText:SetPoint("TOP", TgFocusFrameSpellBar, "TOP", 0, 4);
  end

  local frameBorder = _G[targetFrameSpellBarName.."Border"];
  if ( frameBorder ) then
    frameBorder:SetTexture("Interface\\CastingBar\\UI-CastingBar-Border-Small");
    frameBorder:SetWidth(197);
    frameBorder:SetHeight(49);
    frameBorder:ClearAllPoints();
    frameBorder:SetPoint("TOP", TgFocusFrameSpellBar, "TOP", 0, 20);
  end

	local frameBorderShield = _G[targetFrameSpellBarName.."BorderShield"];
	if ( frameBorderShield ) then
		frameBorderShield:SetWidth(197);
		frameBorderShield:SetHeight(49);
		frameBorderShield:ClearAllPoints();
		frameBorderShield:SetPoint("TOP", TgFocusFrameSpellBar, "TOP", -5, 20);
	end

  local frameFlash = _G[targetFrameSpellBarName.."Flash"];
  if ( frameFlash ) then
    frameFlash:SetTexture("Interface\\CastingBar\\UI-CastingBar-Flash-Small");
    frameFlash:SetWidth(197);
    frameFlash:SetHeight(49);
    frameFlash:ClearAllPoints();
    frameFlash:SetPoint("TOP", TgFocusFrameSpellBar, "TOP", 0, 20);
  end
end

function TgFocus_Spellbar_OnLoad (self)
  self:RegisterEvent("PLAYER_FOCUS_CHANGED");
  self:RegisterEvent("CVAR_UPDATE");
  self:RegisterEvent("PLAYER_LOGIN");
  
  CastingBarFrame_OnLoad(self, "focus", false, true);

  local name = self:GetName();

  local barIcon =_G[name.."Icon"];
  barIcon:Show();

  TgSetTargetSpellbarAspect();
  
  --The target casting bar has less room for text than most, so shorten it
  _G[name.."Text"]:SetWidth(150)
  -- check to see if the castbar should be shown
  if ( GetCVar("showTargetCastbar") == "0") then
    self.showCastbar = false;  
  end
end

function TgFocus_Spellbar_OnEvent (self, event, ...)
  local arg1 = ...
  
  --  Check for target specific events
  if ( (event == "PLAYER_LOGIN") or ((event == "CVAR_UPDATE") and (arg1 == "SHOW_TARGET_CASTBAR")) ) then
    if ( GetCVar("showTargetCastbar") == "0") then
      self.showCastbar = false;
    else
      self.showCastbar = true;
    end
    
    if ( not self.showCastbar ) then
      self:Hide();
    elseif ( self.casting or self.channeling ) then
      self:Show();
    end
    return;
  elseif ( event == "PLAYER_FOCUS_CHANGED" ) then
    -- check if the new target is casting a spell
    local nameChannel  = UnitChannelInfo(self.unit);
    local nameSpell  = UnitCastingInfo(self.unit);
    if ( nameChannel ) then
      event = "UNIT_SPELLCAST_CHANNEL_START";
      arg1 = "focus";
    elseif ( nameSpell ) then
      event = "UNIT_SPELLCAST_START";
      arg1 = "focus";
    else
      self.casting = nil;
      self.channeling = nil;
      self:SetMinMaxValues(0, 0);
      self:SetValue(0);
      self:Hide();
      return;
    end
    -- The position depends on the classification of the target
    TgFocus_Spellbar_AdjustPosition();
  end
  CastingBarFrame_OnEvent(self, event, arg1, select(2, ...));
end

function TgFocus_Spellbar_AdjustPosition ()
  local yPos = 5;
  if ( TgFocusFrame.auraRows ) then
    if ( TgFocusFrame.auraRows <= NUM_TOT_AURA_ROWS ) then
      yPos = 38;
    else
      yPos = 19 * TgFocusFrame.auraRows;
    end
  end
  if ( TgTargetofFocusFrame:IsShown() ) then
    if ( yPos <= 25 ) then
      yPos = yPos + 25;
    end
  else
    yPos = yPos - 5;
    local classification = UnitClassification("focus");
    if ( (yPos < 17) and ((classification == "worldboss") or (classification == "rareelite") or (classification == "elite") or (classification == "rare")) ) then
      yPos = 17;
    end
  end
  TgFocusFrameSpellBar:SetPoint("BOTTOM", "TgFocusFrame", "BOTTOM", -15, -yPos);
end

function TgFocusFrame_OnDragStart(self)
  if (not FocusFrameOptions.lockpos) then
    self:GetParent():StartMoving();
    self.isMoving = true;
  end
end

function TgFocusFrame_OnDragStop(self)
  self:GetParent():StopMovingOrSizing();
  self.isMoving = false;
  TgFocusFrame_SavePos();
end

function TgFocusFrame_OnEnter(self)
  GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
  if (not FocusFrameOptions.lockpos) then
    GameTooltip:SetText(FOCUSFRAME_DRAG, nil, nil, nil, nil, 1);
  else
    GameTooltip:SetText(FOCUSFRAME_DRAG_LOCKED, nil, nil, nil, nil, 1);
  end
end
