-- Get core objects
local Gladdy = LibStub("AceAddon-3.0"):GetAddon("Gladdy")
local L = LibStub("AceLocale-3.0"):GetLocale("Gladdy")

-- Lua calls
local pairs = pairs

-- Blizzard API
local GetSpellInfo = GetSpellInfo

-- Auras
Gladdy._AURAS_ = {
    -- Cyclone
    [GetSpellInfo(33786)] = {
        track = "debuff",
        dr = "cyclone-blind",
        duration = 6,
        priority = 40,
        icon = select(3, GetSpellInfo(33786)),
    },
    -- Hibernate
    [GetSpellInfo(18658)] = {
        track = "debuff",
        dr = "sleep",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(18658)),
    },
    -- Entangling Roots
    [GetSpellInfo(26989)] = {
        track = "debuff",
        dr = "root",
        duration = 10,
        priority = 30,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(26989)),
    },
    -- Feral Charge
    [GetSpellInfo(16979)] = {
        track = "debuff",
        dr = "root",
        duration = 4,
        priority = 30,
        icon = select(3, GetSpellInfo(16979)),
    },
    -- Bash
    [GetSpellInfo(8983)] = {
        track = "debuff",
        dr = "stun",
        duration = 4,
        priority = 40,
        icon = select(3, GetSpellInfo(8983)),
    },
    -- Pounce
    [GetSpellInfo(9005)] = {
        track = "debuff",
        dr = "stun",
        duration = 3,
        priority = 40,
        icon = select(3, GetSpellInfo(9005)),
    },
    -- Maim
    [GetSpellInfo(22570)] = {
        track = "debuff",
        dr = "disorient",
        duration = 6,
        priority = 40,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(22570)),
    },
    -- Innervate
    [GetSpellInfo(29166)] = {
        track = "buff",
        duration = 20,
        priority = 10,
    },
    -- Moonkin Form
    [GetSpellInfo(24858)] = {
        spec = L["Balance"],
    },

    -- The Beast Within
    [GetSpellInfo(34692)] = {
        track = "buff",
        duration = 18,
        priority = 20,
        spec = L["Beast Mastery"],
    },
    -- Freezing Trap Effect
    [GetSpellInfo(14309)] = {
        track = "debuff",
        dr = "freezing-trap",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(14309)),
    },
    -- Wyvern Sting
    [GetSpellInfo(19386)] = {
        track = "debuff",
        dr = "sleep",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        dispel = "poison",
        icon = select(3, GetSpellInfo(19386)),
    },
    -- Scatter Shot
    [GetSpellInfo(19503)] = {
        track = "debuff",
        dr = "scatter-shot",
        duration = 4,
        priority = 40,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(19503)),
    },
    -- Silencing Shot
    [GetSpellInfo(34490)] = {
        track = "debuff",
        duration = 3,
        priority = 15,
    },
    -- Intimidation
    [GetSpellInfo(19577)] = {
        track = "debuff",
        dr = "stun",
        duration = 2,
        priority = 40,
        icon = select(3, GetSpellInfo(19577)),
    },
    -- Spirit Bond
    [GetSpellInfo(20895)] = {
        spec = L["Beast Mastery"],
    },

    -- Polymorph
    [GetSpellInfo(12826)] = {
        track = "debuff",
        dr = "disorient",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(12826)),
    },
    -- Dragon's Breath
    [GetSpellInfo(31661)] = {
        track = "debuff",
        dr = "dragons-breath",
        duration = 3,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(31661)),
    },
    -- Frost Nova
    [GetSpellInfo(27088)] = {
        track = "debuff",
        dr = "root",
        duration = 8,
        priority = 30,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(27088)),
    },
    -- Freeze (Water Elemental)
    [GetSpellInfo(33395)] = {
        track = "debuff",
        dr = "root",
        duration = 8,
        priority = 30,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(33395)),
    },
    -- Counterspell - Silence
    [GetSpellInfo(18469)] = {
        track = "debuff",
        duration = 4,
        priority = 15,
    },
    -- Ice Block
    [GetSpellInfo(45438)] = {
        track = "buff",
        duration = 10,
        priority = 20,
    },
    -- Combustion
    [GetSpellInfo(11129)] = {
        spec = L["Fire"],
    },
    -- Ice Barrier
    [GetSpellInfo(33405)] = {
        spec = L["Frost"],
    },

    -- Hammer of Justice
    [GetSpellInfo(10308)] = {
        track = "debuff",
        dr = "stun",
        duration = 6,
        priority = 40,
        dispel = "magic",
        icon = select(3, GetSpellInfo(10308)),
    },
    -- Repentance
    [GetSpellInfo(20066)] = {
        track = "debuff",
        dr = "disorient",
        duration = 6,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(20066)),
    },
    -- Blessing of Protection
    [GetSpellInfo(10278)] = {
        track = "buff",
        duration = 10,
        priority = 10,
    },
    -- Blessing of Freedom
    [GetSpellInfo(1044)] = {
        track = "buff",
        duration = 14,
        priority = 10,
    },
    -- Divine Shield
    [GetSpellInfo(642)] = {
        track = "buff",
        duration = 12,
        priority = 20,
    },
    -- Light's Grace
    [GetSpellInfo(31836)] = {
        spec = L["Holy"],
    },
    -- Seal of Command
    [GetSpellInfo(20375)] = {
        spec = L["Retribution"],
    },

    -- Psychic Scream
    [GetSpellInfo(8122)] = {
        track = "debuff",
        dr = "fear",
        duration = 8,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(8122)),
    },
    -- Chastise
    [GetSpellInfo(44047)] = {
        track = "debuff",
        dr = "root",
        duration = 2,
        priority = 30,
        icon = select(3, GetSpellInfo(44047)),
    },
    -- Mind Control
    [GetSpellInfo(605)] = {
        track = "debuff",
        dr = "charm",
        duration = 10,
        priority = 40,
        dispel = "magic",
        icon = select(3, GetSpellInfo(605)),
    },
    -- Pain Suppression
    [GetSpellInfo(33206)] = {
        track = "buff",
        duration = 8,
        priority = 10,
    },
    -- Silence
    [GetSpellInfo(15487)] = {
        track = "debuff",
        duration = 5,
        priority = 15,
    },
    -- Shadowform
    [GetSpellInfo(15473)] = {
        spec = L["Shadow"],
    },
    -- Focused Will
    [GetSpellInfo(45242)] = {
        spec = L["Discipline"],
    },

    -- Sap
    [GetSpellInfo(6770)] = {
        track = "debuff",
        dr = "disorient",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(6770)),
    },
    -- Blind
    [GetSpellInfo(2094)] = {
        track = "debuff",
        dr = "cyclone-blind",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(2094)),
    },
    -- Cheap Shot
    [GetSpellInfo(1833)] = {
        track = "debuff",
        dr = "stun",
        duration = 4,
        priority = 40,
        icon = select(3, GetSpellInfo(1833)),
    },
    -- Kidney Shot
    [GetSpellInfo(8643)] = {
        track = "debuff",
        dr = "kidney-shot",
        duration = 6,
        priority = 40,
        icon = select(3, GetSpellInfo(8643)),
    },
    -- Gouge
    [GetSpellInfo(1776)] = {
        track = "debuff",
        dr = "disorient",
        duration = 4,
        priority = 40,
        fadeOnDamage = true,
        icon = select(3, GetSpellInfo(1776)),
    },
    -- Kick - Silence
    [GetSpellInfo(18425)] = {
        track = "debuff",
        duration = 2,
        priority = 15,
    },
    -- Garrote - Silence
    [GetSpellInfo(1330)] = {
        track = "debuff",
        duration = 3,
        priority = 15,
    },
    -- Cloak of Shadows
    [GetSpellInfo(31224)] = {
        track = "buff",
        duration = 5,
        priority = 20,
    },
    -- Shadowstep
    [GetSpellInfo(36554)] = {
        spec = L["Subtlety"],
    },

    -- Fear
    [GetSpellInfo(5782)] = {
        track = "debuff",
        dr = "fear",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(5782)),
    },
    -- Death Coil
    [GetSpellInfo(27223)] = {
        track = "debuff",
        dr = "horror",
        duration = 3,
        priority = 40,
        icon = select(3, GetSpellInfo(27223)),
    },
    -- Shadowfury
    [GetSpellInfo(30283)] = {
        track = "debuff",
        dr = "stun",
        duration = 2,
        priority = 40,
        icon = select(3, GetSpellInfo(30283)),
    },
    -- Seduction (Succubus)
    [GetSpellInfo(6358)] = {
        track = "debuff",
        dr = "fear",
        duration = 10,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(6358)),
    },
    -- Howl of Terror
    [GetSpellInfo(5484)] = {
        track = "debuff",
        dr = "fear",
        duration = 8,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(5484)),
    },
    -- Spell Lock (Felhunter)
    [GetSpellInfo(19647)] = {
        track = "debuff",
        duration = 3,
        priority = 15,
    },
    -- Soul Link
    [GetSpellInfo(19028)] = {
        spec = L["Demonology"],
    },
    -- Nether Protection
    [GetSpellInfo(30302)] = {
        spec = L["Destruction"],
    },

    -- Intimidating Shout
    [GetSpellInfo(5246)] = {
        track = "debuff",
        dr = "fear",
        duration = 8,
        priority = 40,
        fadeOnDamage = true,
        dispel = "magic",
        icon = select(3, GetSpellInfo(5246)),
    },
    -- Concussion Blow
    [GetSpellInfo(12809)] = {
        track = "debuff",
        dr = "stun",
        duration = 5,
        priority = 40,
        icon = select(3, GetSpellInfo(12809)),
    },
    -- Intercept Stun
    [GetSpellInfo(20253)] = {
        track = "debuff",
        dr = "stun",
        duration = 3,
        priority = 40,
        icon = select(3, GetSpellInfo(20253)),
    },
    -- Spell Reflection
    [GetSpellInfo(23920)] = {
        track = "buff",
        duration = 5,
        priority = 10,
    },
    -- Second Wind
    [GetSpellInfo(29838)] = {
        spec = L["Arms"],
    },

    -- War Stomp
    [GetSpellInfo(20549)] = {
        track = "debuff",
        dr = "stun",
        duration = 2,
        priority = 40,
        icon = select(3, GetSpellInfo(20549)),
    },
    -- Arcane Torrent
    [GetSpellInfo(28730)] = {
        track = "debuff",
        duration = 2,
        priority = 15,
        icon = select(3, GetSpellInfo(28730)),
    },
}

-- Spells
Gladdy.spells = {
    -- Force of Nature
    [GetSpellInfo(33831)] = L["Balance"],
    -- Mangle (Cat)
    [GetSpellInfo(33983)] = L["Feral"],
    -- Mangle (Bear)
    [GetSpellInfo(33987)] = L["Feral"],
    -- Leader of the Pack
    [GetSpellInfo(17007)] = L["Feral"],
    -- Swiftmend
    [GetSpellInfo(18562)] = L["Restoration"],

    -- Intimidation
    [GetSpellInfo(19577)] = L["Beast Mastery"],
    -- Silencing Shot
    [GetSpellInfo(34490)] = L["Marksmanship"],
    -- Trueshot Aura
    [GetSpellInfo(27066)] = L["Marksmanship"],
    -- Wyvern Sting
    [GetSpellInfo(27068)] = L["Survival"],

    -- Arcane Power
    [GetSpellInfo(12042)] = L["Arcane"],
    -- Dragon's Breath
    [GetSpellInfo(33043)] = L["Fire"],
    -- Blast Wave
    [GetSpellInfo(33933)] = L["Fire"],
    -- Ice Barrier
    [GetSpellInfo(33405)] = L["Frost"],
    -- Summon Water Elemental
    [GetSpellInfo(31687)] = L["Frost"],

    -- Holy Shock
    [GetSpellInfo(33072)] = L["Holy"],
    -- Divine Favor
    [GetSpellInfo(20216)] = L["Holy"],
    -- Divine Illumination
    [GetSpellInfo(31842)] = L["Holy"],
    -- Avenger's Shield
    [GetSpellInfo(32700)] = L["Protection"],
    -- Seal of Command
    [GetSpellInfo(27170)] = L["Retribution"],
    -- Crusader Strike
    [GetSpellInfo(35395)] = L["Retribution"],
    -- Repentance
    [GetSpellInfo(20066)] = L["Retribution"],

    -- Power Infusion
    [GetSpellInfo(10060)] = L["Discipline"],
    -- Pain Suppression
    [GetSpellInfo(33206)] = L["Discipline"],
    -- Blessed Resilience
    [GetSpellInfo(33143)] = L["Holy"],
    -- Circle of Healing
    [GetSpellInfo(34861)] = L["Holy"],
    -- Shadowform
    [GetSpellInfo(15473)] = L["Shadow"],
    -- Vampiric Touch
    [GetSpellInfo(34917)] = L["Shadow"],

    -- Mutilate
    [GetSpellInfo(34413)] = L["Assassination"],
    -- Adrenaline Rush
    [GetSpellInfo(13750)] = L["Combat"],
    -- Shadowstep
    [GetSpellInfo(36554)] = L["Subtlety"],

    -- Elemental Mastery
    [GetSpellInfo(16166)] = L["Elemental"],
    -- Shamanistic Rage
    [GetSpellInfo(30823)] = L["Enhancement"],
    -- Stormstrike
    [GetSpellInfo(17364)] = L["Enhancement"],
    -- Mana Tide Totem
    [GetSpellInfo(16190)] = L["Restoration"],
    -- Earth Shield
    [GetSpellInfo(32594)] = L["Restoration"],

    -- Unstable Affliction
    [GetSpellInfo(30405)] = L["Affliction"],
    -- Siphon Life
    [GetSpellInfo(30911)] = L["Affliction"],
    -- Shadowfury
    [GetSpellInfo(30414)] = L["Destruction"],

    -- Mortal Strike
    [GetSpellInfo(30330)] = L["Arms"],
    -- Death Wish
    [GetSpellInfo(12292)] = L["Arms"],
    -- Bloodthirst
    [GetSpellInfo(30335)] = L["Fury"],
    -- Concussion Blow
    [GetSpellInfo(12809)] = L["Protection"],
    -- Devastate
    [GetSpellInfo(30022)] = L["Protection"],
    -- Last Stand
    [GetSpellInfo(12975)] = L["Protection"],
}

-- Dispels
Gladdy.dispels = {
    -- Bestial Wrath
    [GetSpellInfo(19574)] = {
        immunne = true,
    },

    -- Ice Block
    [GetSpellInfo(45438)] = {
        immunne = true,
    },

    -- Divine Shield
    [GetSpellInfo(642)] = {
        immunne = true,
    },
    -- Cleanse
    [GetSpellInfo(4987)] = {
        target = "dest",
        magic = true,
        poison = true,
    },

    -- Dispel Magic
    [GetSpellInfo(988)] = {
        target = "dest",
        magic = true,
    },

    -- Tremor totem
    [GetSpellInfo(8143)] = {
        target = "dest",
        fear = true,
        charm = true,
        sleep = true,
    },

    -- Berserker Rage
    [GetSpellInfo(18499)] = {
        target = "self",
        fear = true,
    },
    -- Death Wish
    [GetSpellInfo(12292)] = {
        target = "self",
        fear = true,
    },

    -- Will of the Forsaken
    [GetSpellInfo(7744)] = {
        target = "self",
        fear = true,
        charm = true,
        sleep = true,
    },
}

--- Gladdy:ConvertAuraList
-- Update internal auralist for event usage
function Gladdy:ConvertAuraList()
    self.auras = {}

    for index, aura in pairs(self.db.auras) do
        if (not aura.deleted) then
            self.auras[aura.name] = self._AURAS_[aura.name]
        end
    end
end